<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\User;
use DataTables;
use Session;
use App\Models\Setting;
use App\Models\CartMember;
use App\Models\FamilyMember;
use Hash;
use Cart;
use Auth;
class CartController extends Controller
{
   
   public function show_addcart(Request $request){        
        $options = array("mrp"=>$request->get("mrp"),"parameter"=>$request->get("parameter"),"item_id"=>$request->get("id"));
        Cart::add(rand().time(),$request->get("name"),$request->get("price"),1,$options);
        $cartCollection = Cart::getContent();
        return $cartCollection->count();
   }

   public function add_cart_member(Request $request){
//    dd($request->all());
    $list = $request->get("member");
    
    if(empty($list)){
        Session::flash('message',"Select Any Member.."); 
        Session::flash('alert-class', 'alert-danger');
        return redirect()->back();
    }else{
        foreach($list as $l){
            $data = new CartMember();
            $data->user_id = Auth::id();
            $data->family_member_id = $l;
            $data->type_id = $request->get("type_id");
            $data->type = $request->get("type");
            $data->parameter = $request->get("parameter");
            $data->save();
        } 
        Session::flash('message',"Test Book Successfully"); 
        Session::flash('alert-class', 'alert-success');
        return redirect('checkout');
    }
    
   }

   public function show_deletecart(Request $request){
        $setting = Setting::find(1);
        $data = CartMember::where("id",$request->get("id"))->first();
        $totalcart = count(CartMember::where("user_id",Auth::id())->where("family_member_id",$data->member_id)->get());        
        $txt = 0;
        $total = $this->getcartsubtotal();
        $txt_charges = ($total*$setting->txt_charge)/100;
        $main_total = $total+$txt_charges;
        $data1 = array("subtotal"=>number_format($total,2,'.',''),"txt"=>number_format($txt_charges,2,'.',''),"main_total"=>number_format($main_total,2,'.',''),"total_member_cart"=>$totalcart);
        return $data1;
   }

   public function deletemembercart(Request $request){
        $setting = Setting::find(1);
        $data = CartMember::where("id",$request->get("id"))->first();
        $member_id = $data->member_id;
        $data->delete();
        $totalcart = count(CartMember::where("user_id",Auth::id())->where("family_member_id",$member_id)->get());        
        $txt = 0;
        $total = $this->getcartsubtotal();
        $txt_charges = ($total*$setting->txt_charge)/100;
        $main_total = $total+$txt_charges;
        
        $data1 = array("subtotal"=>number_format($total,2,'.',''),"txt"=>number_format($txt_charges,2,'.',''),"main_total"=>number_format($main_total,2,'.',''),"total_member_cart"=>$totalcart);
        return $data1;
   }

   public function addcustomizepackage(Request $request){
    $cartCollection = Cart::getContent();
     $ls = array();
     foreach ($cartCollection as $k) {
         $ls[] = array(
                'id' => $k['id'], // inique row ID
                'name' => $k['name'],
                'price' => $k['price'],
                'quantity' => 1,
                'attributes' => $k['attributes']
            );
     }
     Cart::session($request->get("id"))->add($ls);
     $store = new CartMember();
     $store->user_id = Auth::id();
     $store->family_member_id = $request->get("id");
     $store->save();    
     $setting = Setting::find(1);
     $getcurrency = explode("-",$setting->currency);
     $currency = $getcurrency[1];
     $getfamilymember = FamilyMember::find($request->get("id"));
     $txt = '<div class="col-xl-12 col-lg-12 col-md-12 doctors-block" id="cart_member_'.$request->get("id").'"><div class="team-block-three"><div class="inner-box"><div class="lower-content"><ul class="name-box clearfix"><li class="name"> <h3><a href="#">'.$getfamilymember->name.' | '.$getfamilymember->relation.'</a></h3></li></ul><span class="designation">'.$getfamilymember->gender.', '.$getfamilymember->age.' years</span>';
                $cartmem = Cart::session($request->get("id"))->getContent();
                foreach($cartmem as $item){
                    $discount = 100 * ($item['attributes']['mrp'] - $item['price']) / $item['attributes']['mrp'];
                    $txt = $txt.'<div class="row" id="member_'.$request->get("id").'_'.$item['id'].'" style="border-top: 1px solid #453f85;"><div class="col-md-9"><p>'.$item['name'].'</p><span>Parameters Included : '.$item['attributes']['parameter'].'</span><p><span style="text-decoration: line-through;    color: red;">'.$currency.$item['attributes']['mrp'].'</span> '.$currency.$item['price'].'</p></div><div class="col-md-3" ><p style="margin-top: 8px;margin-bottom: 19px;"><span style="background: green;color: white;    padding: 2px;">'.round($discount).'%</span></p><p><span></span></p> <input type="hidden" id="member_item_id_'.$request->get("id").'" value="'.$item['id'].'"><span><a href="javascript:void(0)" onclick="removememberitemoncart('.$request->get("id").')"><i class="fa fa-trash"></i></a></span></div></div>';
                }
        $txt = $txt.'</div></div></div></div>';
        $total = 0;
        $store = CartMember::where("user_id",Auth::id())->get();
        if(count($store)>0){
            foreach($store as $s){
                $total = $total+Cart::session($s->family_member_id)->getTotal();  
            }    
        }
        
        $txt_charges = ($total*$setting->txt_charge)/100;
        $main_total = $total+$txt_charges;
        $data = array("content"=>$txt,"subtotal"=>number_format($total,2,'.',''),"txt"=>number_format($txt_charges,2,'.',''),"main_total"=>number_format($main_total,2,'.',''));  
        return $data;
   }



   public function removecustomizepackage(Request $request){
        $data = Cart::session($request->get("id"))->getContent();
        foreach($data as $d){
            Cart::session($request->get("id"))->remove($d['id']);
        }    
        CartMember::where("user_id",Auth::id())->where("family_member_id",$request->get("id"))->delete();
        $total = 0;
        $store = CartMember::where("user_id",Auth::id())->get();
        if(count($store)>0){
            foreach($store as $s){
                $total = $total+Cart::session($s->family_member_id)->getTotal();  
            }    
        }
        $setting = Setting::find(1);
        $txt_charges = ($total*$setting->txt_charge)/100;
        $main_total = $total+$txt_charges;
        $data = array("content"=>"","subtotal"=>number_format($total,2,'.',''),"txt"=>number_format($txt_charges,2,'.',''),"main_total"=>number_format($main_total,2,'.',''));  
        return $data;
   }

   public function viewcartdata(){
      Cart::clear();
      $cartCollection = Cart::getContent();
      $data = Cart::session(1)->getContent();

      echo "<pre>";
      print_r($cartCollection);
      print_r($data);
      exit;
   }
}
