<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\User;
use DataTables;
use Session;
use Auth;
use Hash;

class CategoryController extends Controller
{
    public function show_category(){
        return view("admin.Category.default");
    }

    public function categorydatatable(){
         $category =Category::orderBy('id','DESC')->get();
         return DataTables::of($category)
            ->editColumn('id', function ($category) {
                return $category->id;
            })
            ->editColumn('cat_name', function ($category) {
                return $category->name;
            })
            ->editColumn('cat_image', function ($category) {
                return url("storage/app/public/category")."/".$category->image;
            })      
            ->editColumn('action', function ($category) {
                $edittext =__('message.Edit');
                $deletetext = __('message.Delete');
                $edit = url('savecategory',array('id'=>$category->id));
                $delete = url('deletecategory',array('id'=>$category->id));
                return '<a  href="'.$edit.'" rel="tooltip"  class="btn btn-primary" data-original-title="banner" style="margin-right: 10px;color: white !important;">'.$edittext.'</a><a onclick="delete_record(' . "'" . $delete. "'" . ')" rel="tooltip"  class="btn btn-danger" data-original-title="Remove" style="margin-right: 10px;color:white !important">'.$deletetext.'</a>';              
            })           
            ->make(true);
    }
    public function show_savecategory($id){
        $data = Category::find($id);
        return view("admin.Category.savecategory")->with("id",$id)->with("data",$data);
    }
    public function show_update_category(Request $request){
        if($request->get("id")==0){
            $store = new Category();    
            $rel_img = "";  
            $msg = __('message.Category Add Successfully');
        }else{
            $store=Category::find($request->get("id"));
            $msg = __('message.Category Update Successfully');
            if($store->image!=""&&$request->get("basic_img")!=""){
                $this->removeImage('category/' . $store->image);
            }
        }       
        $store->name = $request->get("name");
        if($request->file("upload_image")){
            if($request->get("basic_img")!=""){
                $store->image = $this->fileuploadFileImage($request, 'category', 'upload_image');
            }else{
                $store->image = $this->fileuploadFileImage($request, 'category', 'upload_image');
            }
        }
        $store->save();
        Session::flash('message',$msg); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('admin-category');
    }
    public function deletecategory($id){        
        $data = Category::find($id); 
        $data->delete();       
        Session::flash('message',__('message.Category Delete Successfully')); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('admin-category');
    }
}
