@extends('admin.layout.index')
@section('title')
{{__("message.Send Notification")}}
@stop
@section('content')
<div class="page-header">
	<h3 class="page-title">{{__("message.Notification")}} </h3>
	<nav aria-label="breadcrumb">	      		
       <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="{{route('admin-dashboard')}}">{{__("message.Home")}}</a></li>
         <li class="breadcrumb-item active">{{__("message.Send Notification")}}</li>
       </ol>
     </nav>	      	
</div>
<div class="row">
	<div class="col-lg-12 grid-margin stretch-card">
       <div class="card">                	
         <div class="card-body">
         	 @if(Session::has('message'))
            <div class="col-sm-12">
               <div class="alert  {{ Session::get('alert-class', 'alert-info') }} alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  </button>
               </div>
            </div>
            @endif
            <div class="table-responsive">
                <form action="{{route('send_notification')}}" method="post" enctype="multipart/form-data">
                   {{csrf_field()}}
                   
                      <div class="form-group">
                         <label for="message">Message<span class="reqfield">*</span></label>
                         <textarea type="text" id="message" name="message" class="form-control" placeholder='{{__("message.Enter Message")}}' required="" ></textarea>
                      </div>
                     	
                      <div class="row">
                         <div class="col-12">
                         	 @if(Session::get("is_demo")==1)
                            <input type="button" value='{{__("message.Save Notification")}}' class="btn btn-success" onclick="disablebtn()">
                             @else
                            <input type="submit" value='{{__("message.Save Notification")}}' class="btn btn-success">
                             @endif
                            <a href="{{route('admin-category')}}" class="btn btn-danger">{{__("message.Cancel")}}</a>
                         </div>
                      </div>
               	</form>
              </div>
         </div>
       </div>
     </div>
</div>
@endsection