@extends('front.layout')
@section('title')
    {{ __('message.Dashboard') }}
@stop
@section('meta-data')
    <meta property="og:type" content="website" />
    <meta property="og:url" content="{{ route('dashboard') }}" />
    <meta property="og:title" content="{{ __('message.site_name') }}" />
    <meta property="og:image" content="{{ asset('public/img/') . '/' . $setting->logo }}" />
    <meta property="og:image:width" content="250px" />
    <meta property="og:image:height" content="250px" />
    <meta property="og:site_name" content="{{ __('message.site_name') }}" />
    <meta property="og:description" content="{{ __('message.meta_description') }}" />
    <meta property="og:keyword" content="{{ __('message.meta_keyword') }}" />
    <link rel="shortcut icon" href="{{ asset('public/img/') . '/' . $setting->favicon }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
@stop
@section('content')
    <?php $res_curr = explode('-', $setting->currency); ?>
    <section class="page-title-two">
        <div class="title-box centred bg-color-2">
            <div class="pattern-layer">
                <?php
                $sharp70 = asset('public/front/Docpro/assets/images/shape/shape-70.png');
                $sharp71 = asset('public/front/Docpro/assets/images/shape/shape-71.png');
                ?>
                <div class="pattern-1" style="background-image: url('{{ $sharp70 }}');"></div>
                <div class="pattern-2" style="background-image: url('{{ $sharp71 }}');"></div>
            </div>
            <div class="auto-container" style="z-index: auto;">
                <div class="title">
                    <h1 style="color:white">{{ __('message.Dashboard') }}</h1>
                </div>
            </div>
        </div>
        <div class="lower-content">
            <div class="auto-container">
                <ul class="bread-crumb clearfix">
                    <li><a href="{{ route('home') }}">{{ __('message.Home') }}</a></li>
                    <li>{{ __('message.Dashboard') }}</li>
                </ul>
            </div>
        </div>
    </section>
    <section class="doctors-dashboard bg-color-3">
        <div class="left-panel">
            <div class="profile-box">
                <div class="upper-box">
                    <?php
                    if (Auth::user()->profile_pic != '') {
                        $path = env('APP_URL') . 'storage/app/public/profile' . '/' . Auth::user()->profile_pic;
                    } else {
                        $path = asset('public/img/default_user.png');
                    }
                    ?>

                    <figure class="profile-image"><img src="{{ $path }}" alt=""></figure>
                    <div class="title-box centred">
                        <div class="inner">
                            <h3>{{ Auth::user()->name }}</h3>
                            <p><i class="fas fa-envelope"></i>{{ Auth::user()->email }}</p>
                        </div>
                    </div>
                </div>
                <div class="profile-info">
                    <ul class="list clearfix">
                        <li><a href="{{ route('dashboard') }}" class="current"><i
                                    class="fas fa-columns"></i>{{ __('message.Dashboard') }}</a></li>

                        <li><a href="{{ route('my-family-member') }}"><i
                                    class="fas fa-clock"></i>{{ __('message.My Family Members') }}</a></li>
                        <li><a href="{{ route('my-addresses') }}"><i
                                    class="fas fa-comments"></i>{{ __('message.My Addresses') }}</li>
                        <li><a href="{{ route('user-profile') }}"><i
                                    class="fas fa-user"></i>{{ __('message.My Profile') }}</a></li>
                        <li><a href="{{ route('user-change-password') }}"><i
                                    class="fas fa-unlock-alt"></i>{{ __('message.Change Password') }}</a></li>
                        <li><a href="{{ route('user-logout') }}"><i
                                    class="fas fa-sign-out-alt"></i>{{ __('message.Logout') }}</a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="right-panel">
            <div class="content-container">
                <div class="outer-container">
                    <div class="feature-content">
                        <div class="row clearfix">
                            <div class="col-xl-4 col-lg-12 col-md-12 feature-block">
                                <div class="feature-block-two">
                                    <div class="inner-box">
                                        <div class="pattern">
                                            <?php
                                            $sharp70 = asset('public/front/Docpro/assets/images/shape/shape-79.png');
                                            $sharp71 = asset('public/front/Docpro/assets/images/shape/shape-80.png');
                                            $sharp81 = asset('public/front/Docpro/assets/images/shape/shape-81.png');
                                            $sharp82 = asset('public/front/Docpro/assets/images/shape/shape-82.png');
                                            $sharp83 = asset('public/front/Docpro/assets/images/shape/shape-83.png');
                                            $sharp84 = asset('public/front/Docpro/assets/images/shape/shape-84.png');
                                            ?>
                                            <div class="pattern-1" style="background-image: url('{{ $sharp70 }}');">
                                            </div>
                                            <div class="pattern-2" style="background-image: url('{{ $sharp71 }}');">
                                            </div>
                                        </div>
                                        <div class="icon-box"><i class="icon-Dashboard-1"></i></div>
                                        <h3>{{ $totalorders }}</h3>
                                        <h5>{{ __('message.Total Appointment') }}</h5>
                                        <p></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-12 col-md-12 feature-block">
                                <div class="feature-block-two">
                                    <div class="inner-box">
                                        <div class="pattern">
                                            <div class="pattern-1" style="background-image: url('{{ $sharp81 }}');">
                                            </div>
                                            <div class="pattern-2" style="background-image: url('{{ $sharp82 }}');">
                                            </div>
                                        </div>
                                        <div class="icon-box"><i class="icon-Dashboard-2"></i></div>
                                        <h3>{{ $pendingorders }}</h3>
                                        <h5>{{ __('message.Pending Appointment') }}</h5>
                                        <p></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-12 col-md-12 feature-block">
                                <div class="feature-block-two">
                                    <div class="inner-box">
                                        <div class="pattern">
                                            <div class="pattern-1" style="background-image: url('{{ $sharp83 }}');">
                                            </div>
                                            <div class="pattern-2" style="background-image: url('{{ $sharp84 }}');">
                                            </div>
                                        </div>
                                        <div class="icon-box"><i class="icon-Dashboard-3"></i></div>
                                        <h3>{{ $completeorders }}</h3>
                                        <h5>{{ __('message.Complete Appointment') }}</h5>
                                        <p></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="doctors-appointment">
                        <div class="title-box">
                            <h3>{{ __('message.Your Appointments') }}</h3>
                            <div class="btn-box">
                                <a href="{{ route('dashboard', ['type' => 'past']) }}"
                                    class="theme-btn-<?= $type == 1 ? 'one' : 'two' ?>">{{ __('message.Past') }}</a>
                                <a href="{{ route('dashboard', ['type' => 'upcomming']) }}"
                                    class="theme-btn-<?= $type == 2 ? 'one' : 'two' ?>">{{ __('message.Upcoming') }}</a>
                                {{-- <a href="{{ route('dashboard')}}" class="theme-btn-<?= $type == 3 ? 'one' : 'two' ?>">{{__('message.Today')}}</a> --}}
                                @if (Session::has('message'))
                                    <div class="alert {{ Session::get('alert-class', 'alert-info') }} mt-4">
                                        {{ Session::get('message') }}
                                    </div>
                                @endif
                            </div>
                        </div>

                        <div class="doctors-list" style="padding: 5px 24px;">
                            <div class="table-outer">
                                <table class="doctors-table table" id="userdatatable" style="text-align: center;">
                                    <thead class="table-header">
                                        <tr>
                                            <th>{{ __('message.Appt Date') }}</th>
                                            <th>{{ __('message.Appt Time') }}</th>
                                            <th>{{ __('message.Paid Amount') }}</th>
                                            <th>{{ __('message.More') }}</th>
                                            <th>{{ __('message.Print') }}</th>
                                            <th>{{ __('message.Status') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data as $d)
                                            <tr>
                                                <td>{{ $d->date }}</td>
                                                <td>{{ $d->time }}</td>
                                                <td>{{ $res_curr[1] . number_format($d->final_total, 2, '.', '') }}</td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="moreinfo({{ $d->id }})"
                                                        data-toggle="modal" data-target="#addaddress"
                                                        style="position: relative;
                                                            display: inline-block;
                                                            font-size: 15px;
                                                            font-weight: 500;
                                                            line-height: 20px;
                                                            padding: 9px 20px;
                                                            background: #ebfaf8;
                                                            border-radius: 25px;
                                                            margin-right: 10px;">more</a>
                                                </td>
                                                <td>
                                                    <a href="{{ route('printorder', ['id' => $d->id]) }}"
                                                        target="_blank"><span class="print" style="float: unset;"><i
                                                                class="fas fa-print"></i>Print</span>
                                                    </a>
                                                    @if ($d->report != '')
                                                        <a href="{{ asset('storage/app/public/report') . '/' . $d->report }}"
                                                            target="_blank"><span class="print"
                                                                style="float: unset;">View Report</span>
                                                        </a>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($d->status == '1')
                                                        <span class="status pending">{{ __('message.Pending') }}</span>
                                                    @endif
                                                    @if ($d->status == '2')
                                                        <span class="status pending">{{ __('message.Accepted') }}</span>
                                                    @endif
                                                    @if ($d->status == '3')
                                                        <span class="status cancel">{{ __('message.Rejected') }}</span>
                                                    @endif
                                                    @if ($d->status == '4')
                                                        <span class="status cancel">{{ __('message.Refunded') }}</span>
                                                    @endif
                                                    @if ($d->status == '5')
                                                        <span class="status pending">{{ __('message.Collected') }}</span>
                                                    @endif
                                                    @if ($d->status == '6')
                                                        <span class="status pending">{{ __('message.Preparing') }}</span>
                                                    @endif
                                                    @if ($d->status == '7')
                                                        @if ($d->is_feedback == '0')
                                                            <a href="javascript:void(0)"
                                                                onclick="storeorderfeedback('{{ $d->id }}')"
                                                                data-toggle="modal" data-target="#addfeedback"
                                                                style="padding: 5px;" class="theme-btn-one">Add
                                                                Feedback</a>
                                                        @endif
                                                        <span class="status">{{ __('message.Complete') }}</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <div class="modal" id="addaddress">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" id="member_list">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">{{ __('message.Order No') }}: <span id="order_no"></span></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <!-- Modal body -->
                <div style="margin-bottom: 10px;" class="m-4">
                    <p><b>{{ __('message.Name') }} :</b> <span id="customer_name"></span></p>
                    <p><b>{{ __('message.email') }} :</b> <span id="email"></span></p>
                    <p><b>{{ __('message.Address') }} :</b> <span id="address"></span></p>
                    <p><b>{{ __('message.Order Place Date') }} :</b> <span id="order_place_date"> </span></p>
                    <p><b>{{ __('message.Payment Method') }} :</b> <span id="payment_method"> </span></p>
                    <p><b>{{ __('message.Sample Collection Date') }} :</b> <span id="date"> </span></p>
                    <p><b>{{ __('message.Sample Collection time') }} :</b> <span id="time"> </span></p>
                </div>
                <table class="table m-3">
                    <thead>
                        <tr>
                            <td>{{ __('message.Person Info') }}</td>
                            <td>{{ __('message.Item Info') }}</td>
                            <td>{{ __('message.Price') }}</td>
                        </tr>
                    </thead>
                    <tbody id="tableinfo">

                    </tbody>
                    <tfoot>
                        <tr>
                            <td></td>
                            <th>{{ __('message.Subtotal') }}</th>
                            <td id="subtotal"></td>
                        </tr>
                        <tr>
                            <td></td>
                            <th>{{ __('message.Txt Charges') }}</th>
                            <td id="txt_charge"></td>
                        </tr>
                        <tr>
                            <td></td>
                            <th>{{ __('message.Total') }}</th>
                            <th id="total"></th>
                        </tr>
                    </tfoot>

                </table>
                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger"
                        data-dismiss="modal">{{ __('message.Close') }}</button>
                </div>
                </form>
            </div>
        </div>
    </div>



    <div class="modal" id="addfeedback">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">{{ __('message.Add Feedback') }}</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                    <form action="{{ route('post-user-feedback') }}" method="post" id=""
                        class="registration-form">
                        <input type="hidden" name="order_id" id="feedback_order_id">
                        {{ csrf_field() }}
                        <div class="row clearfix">
                            <div class="col-lg-12 col-md-6 col-sm-12 form-group">
                                <label>{{ __('message.Description') }}</label>
                                <textarea name="description" rows="5" type="text" id="description"></textarea>
                            </div>
                        </div>
                </div>
                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="submit" id="address_submit_button"
                        class="btn btn-success">{{ __('message.Add Feedback') }}</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <input type="hidden" value="{{ url('/') }}" id="url_path">
@stop
@section('footer')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#userdatatable').DataTable();
        });

        function moreinfo(id) {

            $.ajax({
                url: $("#url_path").val() + "/getorderdetails1" + "/" + id,
                success: function(data) {
                    var str = JSON.parse(data);

                    $("#order_no").empty();
                    $("#customer_name").empty();
                    $("#email").empty();
                    $("#address").empty();
                    $("#order_place_date").empty();
                    $("#payment_method").empty();
                    $("#date").empty();
                    $("#time").empty();
                    $("#tableinfo").empty();
                    $("#subtotal").empty();
                    $("#txt_charge").empty();
                    $("#total").empty();

                    $("#order_no").html(str.data.id);
                    $("#customer_name").html(str.userinfo.name);
                    $("#email").html(str.userinfo.email);
                    $("#address").html(str.userinfo.address);
                    $("#order_place_date").html(str.data.orderplace_date);
                    $("#payment_method").html(str.data.payment_method);
                    $("#date").html(str.data.date);
                    $("#time").html(str.data.time);
                    var txt = "";
                    for (var i = 0; i < str.data.orderdata.length; i++) {
                        var mrp = str.data.orderdata[i].mrp;
                        var price = str.data.orderdata[i].price;
                        txt = txt + '<tr><td>' + str.data.orderdata[i].memberdetails.name + ' | ' + str.data
                            .orderdata[i].memberdetails.relation + '</br>' + str.data.orderdata[i].memberdetails
                            .gender + '</td><td>Name : ' + str.data.orderdata[i].item_name +
                            '</br>Parameters : ' + str.data.orderdata[i].parameter + '</br>MRP : ' + str
                            .currency + mrp.toFixed(2) + '</br>Price : ' + str.currency + price.toFixed(2) +
                            '</td><td>' + str.currency + price.toFixed(2) + '</td></tr>';
                    }
                    var subtotal = str.data.subtotal;
                    var txtchr = str.data.tax;
                    var finalamount = str.data.final_total;
                    $("#tableinfo").html(txt);
                    $("#subtotal").html(str.currency + subtotal.toFixed(2));
                    $("#txt_charge").html(str.currency + txtchr.toFixed(2));
                    $("#total").html(str.currency + finalamount.toFixed(2));
                }
            });
        }
    </script>
@stop
